/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.util.Arrays;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class IfExprIntervalDayTimeScalarScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final HiveIntervalDayTime arg2Scalar;
    private final HiveIntervalDayTime arg3Scalar;

    public IfExprIntervalDayTimeScalarScalar(int arg1Column, HiveIntervalDayTime arg2Scalar, HiveIntervalDayTime arg3Scalar, int outputColumnNum) {
        super(arg1Column, outputColumnNum);
        this.arg2Scalar = arg2Scalar;
        this.arg3Scalar = arg3Scalar;
    }

    public IfExprIntervalDayTimeScalarScalar() {
        this.arg2Scalar = null;
        this.arg3Scalar = null;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector arg1ColVector = (LongColumnVector)batch.cols[this.inputColumnNum[0]];
        IntervalDayTimeColumnVector outputColVector = (IntervalDayTimeColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        int n = batch.size;
        long[] vector1 = arg1ColVector.vector;
        if (n == 0) {
            return;
        }
        if (arg1ColVector.isRepeating) {
            if ((arg1ColVector.noNulls || !arg1ColVector.isNull[0]) && vector1[0] == 1L) {
                outputColVector.fill(this.arg2Scalar);
            } else {
                outputColVector.fill(this.arg3Scalar);
            }
            return;
        }
        if (arg1ColVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        outputColVector.set(i, vector1[i] == 1L ? this.arg2Scalar : this.arg3Scalar);
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i;
                        outputColVector.set(i, vector1[i = sel[j]] == 1L ? this.arg2Scalar : this.arg3Scalar);
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    outputColVector.set(i, vector1[i] == 1L ? this.arg2Scalar : this.arg3Scalar);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                outputIsNull[i] = false;
                outputColVector.set(i, !arg1ColVector.isNull[i] && vector1[i] == 1L ? this.arg2Scalar : this.arg3Scalar);
            }
        } else {
            Arrays.fill(outputIsNull, 0, n, false);
            for (int i = 0; i != n; ++i) {
                outputColVector.set(i, !arg1ColVector.isNull[i] && vector1[i] == 1L ? this.arg2Scalar : this.arg3Scalar);
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", val " + this.arg2Scalar + ", val " + this.arg3Scalar;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(3).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("int_family"), VectorExpressionDescriptor.ArgumentType.getType("interval_day_time"), VectorExpressionDescriptor.ArgumentType.getType("interval_day_time")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

