/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class VectorColumnSetInfo {
    public int[] longIndices;
    public int[] doubleIndices;
    public int[] stringIndices;
    public int[] decimalIndices;
    public int[] timestampIndices;
    public int[] intervalDayTimeIndices;
    public final int keyCount;
    private int addKeyIndex;
    private int addLongIndex;
    private int addDoubleIndex;
    private int addStringIndex;
    private int addDecimalIndex;
    private int addTimestampIndex;
    private int addIntervalDayTimeIndex;
    public TypeInfo[] typeInfos;
    public ColumnVector.Type[] columnVectorTypes;
    public int[] columnTypeSpecificIndices;

    protected VectorColumnSetInfo(int keyCount) {
        this.keyCount = keyCount;
        this.addKeyIndex = 0;
        this.longIndices = new int[this.keyCount];
        this.addLongIndex = 0;
        this.doubleIndices = new int[this.keyCount];
        this.addDoubleIndex = 0;
        this.stringIndices = new int[this.keyCount];
        this.addStringIndex = 0;
        this.decimalIndices = new int[this.keyCount];
        this.addDecimalIndex = 0;
        this.timestampIndices = new int[this.keyCount];
        this.addTimestampIndex = 0;
        this.intervalDayTimeIndices = new int[this.keyCount];
        this.addIntervalDayTimeIndex = 0;
        this.typeInfos = new TypeInfo[this.keyCount];
        this.columnVectorTypes = new ColumnVector.Type[this.keyCount];
        this.columnTypeSpecificIndices = new int[this.keyCount];
    }

    protected void addKey(TypeInfo typeInfo) throws HiveException {
        ColumnVector.Type columnVectorType = VectorizationContext.getColumnVectorTypeFromTypeInfo(typeInfo);
        switch (columnVectorType) {
            case LONG: 
            case DECIMAL_64: {
                this.longIndices[this.addLongIndex] = this.addKeyIndex;
                ++this.addLongIndex;
                break;
            }
            case DOUBLE: {
                this.doubleIndices[this.addDoubleIndex] = this.addKeyIndex;
                ++this.addDoubleIndex;
                break;
            }
            case BYTES: {
                this.stringIndices[this.addStringIndex] = this.addKeyIndex;
                ++this.addStringIndex;
                break;
            }
            case DECIMAL: {
                this.decimalIndices[this.addDecimalIndex] = this.addKeyIndex;
                ++this.addDecimalIndex;
                break;
            }
            case TIMESTAMP: {
                this.timestampIndices[this.addTimestampIndex] = this.addKeyIndex;
                ++this.addTimestampIndex;
                break;
            }
            case INTERVAL_DAY_TIME: {
                this.intervalDayTimeIndices[this.addIntervalDayTimeIndex] = this.addKeyIndex;
                ++this.addIntervalDayTimeIndex;
                break;
            }
            default: {
                throw new HiveException("Unexpected column vector type " + columnVectorType);
            }
        }
        this.typeInfos[this.addKeyIndex] = typeInfo;
        this.columnVectorTypes[this.addKeyIndex] = columnVectorType;
        ++this.addKeyIndex;
    }

    protected void finishAdding() throws HiveException {
        this.longIndices = Arrays.copyOf(this.longIndices, this.addLongIndex);
        this.doubleIndices = Arrays.copyOf(this.doubleIndices, this.addDoubleIndex);
        this.stringIndices = Arrays.copyOf(this.stringIndices, this.addStringIndex);
        this.decimalIndices = Arrays.copyOf(this.decimalIndices, this.addDecimalIndex);
        this.timestampIndices = Arrays.copyOf(this.timestampIndices, this.addTimestampIndex);
        this.intervalDayTimeIndices = Arrays.copyOf(this.intervalDayTimeIndices, this.addIntervalDayTimeIndex);
    }
}

