/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.registry.LlapServiceInstance;
import org.apache.hadoop.hive.llap.registry.impl.LlapRegistryService;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.hive.ql.exec.tez.HostAffinitySplitLocationProvider;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.split.SplitLocationProvider;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.CounterGroupBase;
import org.apache.tez.common.counters.TezCounters;
import org.slf4j.Logger;

public class Utils {
    public static SplitLocationProvider getSplitLocationProvider(Configuration conf, Logger LOG) throws IOException {
        return Utils.getSplitLocationProvider(conf, true, LOG);
    }

    public static SplitLocationProvider getSplitLocationProvider(Configuration conf, boolean useCacheAffinity, Logger LOG) throws IOException {
        boolean useCustomLocations = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_MODE).equals("llap") && HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_CLIENT_CONSISTENT_SPLITS) && useCacheAffinity;
        String locationProviderClass = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_SPLIT_LOCATION_PROVIDER_CLASS);
        boolean customLocationProvider = !HostAffinitySplitLocationProvider.class.getName().equals(locationProviderClass);
        LOG.info("SplitGenerator using llap affinitized locations: {} locationProviderClass: {}", (Object)useCustomLocations, (Object)locationProviderClass);
        if (customLocationProvider) {
            SplitLocationProvider locationProviderImpl;
            try {
                locationProviderImpl = (SplitLocationProvider)JavaUtils.newInstance((Class)JavaUtils.getClass((String)locationProviderClass, SplitLocationProvider.class), (Class[])new Class[]{Configuration.class}, (Object[])new Object[]{conf});
            }
            catch (Exception e) {
                LOG.warn("Unable to instantiate {} class. Will try no-arg constructor invocation..", (Object)locationProviderClass, (Object)e);
                try {
                    locationProviderImpl = (SplitLocationProvider)JavaUtils.newInstance((Class)JavaUtils.getClass((String)locationProviderClass, SplitLocationProvider.class));
                }
                catch (Exception ex) {
                    throw new IOException(ex);
                }
            }
            return locationProviderImpl;
        }
        if (useCustomLocations) {
            LlapRegistryService serviceRegistry = LlapRegistryService.getClient((Configuration)conf);
            return Utils.getCustomSplitLocationProvider(serviceRegistry, LOG);
        }
        SplitLocationProvider splitLocationProvider = new SplitLocationProvider(){

            public String[] getLocations(InputSplit split) throws IOException {
                if (split == null) {
                    return null;
                }
                String[] locations = split.getLocations();
                if (locations != null && locations.length == 1 && "localhost".equals(locations[0])) {
                    return ArrayUtils.EMPTY_STRING_ARRAY;
                }
                return locations;
            }
        };
        return splitLocationProvider;
    }

    @VisibleForTesting
    static SplitLocationProvider getCustomSplitLocationProvider(LlapRegistryService serviceRegistry, Logger LOG) throws IOException {
        LOG.info("Using LLAP instance " + serviceRegistry.getApplicationId());
        Collection serviceInstances = serviceRegistry.getInstances().getAllInstancesOrdered(true);
        Preconditions.checkArgument((!serviceInstances.isEmpty() ? 1 : 0) != 0, (Object)"No running LLAP daemons! Please check LLAP service status and zookeeper configuration");
        ArrayList<String> locations = new ArrayList<String>(serviceInstances.size());
        for (LlapServiceInstance serviceInstance : serviceInstances) {
            String executors = (String)serviceInstance.getProperties().get("hive.llap.daemon.num.enabled.executors");
            if (executors != null && Integer.parseInt(executors) == 0) {
                locations.add(null);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Not adding " + serviceInstance.getWorkerIdentity() + " with hostname=" + serviceInstance.getHost() + " since executor number is 0");
                continue;
            }
            locations.add(serviceInstance.getHost());
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Adding " + serviceInstance.getWorkerIdentity() + " with hostname=" + serviceInstance.getHost() + " to list for split locations");
        }
        return new HostAffinitySplitLocationProvider(locations);
    }

    public static TezCounters mergeTezCounters(TezCounters counter1, TezCounters counter2) {
        TezCounters merged = new TezCounters();
        if (counter1 != null) {
            for (String counterGroup : counter1.getGroupNames()) {
                merged.addGroup((CounterGroupBase)((CounterGroup)counter1.getGroup(counterGroup)));
            }
        }
        if (counter2 != null) {
            for (String counterGroup : counter2.getGroupNames()) {
                merged.addGroup((CounterGroupBase)((CounterGroup)counter2.getGroup(counterGroup)));
            }
        }
        return merged;
    }
}

