/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeMap;
import org.apache.hadoop.hive.ql.exec.PTFPartition;
import org.apache.hadoop.hive.ql.udf.ptf.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PTFValueCache {
    protected static Logger LOG = LoggerFactory.getLogger(PTFPartition.class);
    private int maxSize;
    private int maxSizePerEvaluator;
    private TreeMap<Range, Object>[] cache;
    private CacheHandler cacheHandler;

    public PTFValueCache(int maxSize) {
        this(maxSize, false);
    }

    public PTFValueCache(int maxSize, boolean collectStatistics) {
        if (maxSize <= 1) {
            throw new IllegalArgumentException("Cache size of 1 and below doesn't make sense.");
        }
        this.maxSize = maxSize;
        this.cacheHandler = collectStatistics ? new InstrumentedCacheHandler() : new BaseCacheHandler();
    }

    public PTFValueCache init(int length) {
        this.cache = new TreeMap[length];
        for (int i = 0; i < length; ++i) {
            this.cache[i] = new TreeMap(new Comparator<Range>(){

                @Override
                public int compare(Range r1, Range r2) {
                    return r1.compareTo(r2);
                }
            });
        }
        this.maxSizePerEvaluator = (int)Math.ceil(this.maxSize / length);
        LOG.info("PTFValueCache is initialized to {} evaluators, maxSize: {} ({} entries / evaluator)", new Object[]{length, this.maxSize, this.maxSizePerEvaluator});
        return this;
    }

    public void put(int evaluatorIndex, Range range, Object value) {
        this.cacheHandler.put(evaluatorIndex, range, value);
    }

    public Object get(int evaluatorIndex, Range range) {
        return this.cacheHandler.get(evaluatorIndex, range);
    }

    public String getStatistics() {
        return this.cacheHandler.getStatistics();
    }

    public int size() {
        return Arrays.asList(this.cache).stream().mapToInt(TreeMap::size).sum();
    }

    public void clear() {
        for (int i = 0; i < this.cache.length; ++i) {
            this.cache[i].clear();
        }
        this.cacheHandler.clear();
    }

    class InstrumentedCacheHandler
    implements CacheHandler {
        int put = 0;
        int hit = 0;
        int miss = 0;
        int evict = 0;

        InstrumentedCacheHandler() {
        }

        @Override
        public void put(int evaluatorIndex, Range range, Object value) {
            PTFValueCache.this.cache[evaluatorIndex].put(range, value);
            ++this.put;
            if (PTFValueCache.this.cache[evaluatorIndex].size() > PTFValueCache.this.maxSizePerEvaluator) {
                PTFValueCache.this.cache[evaluatorIndex].pollFirstEntry();
                ++this.evict;
            }
        }

        @Override
        public Object get(int evaluatorIndex, Range range) {
            if (PTFValueCache.this.cache[evaluatorIndex].containsKey(range)) {
                ++this.hit;
            } else {
                ++this.miss;
            }
            return PTFValueCache.this.cache[evaluatorIndex].get(range);
        }

        @Override
        public String getStatistics() {
            return String.format("PTFValueCache.InstrumentedCacheHandler statistics: put: %d, evict: %d, hit: %d, miss: %d", this.put, this.evict, this.hit, this.miss);
        }

        @Override
        public void clear() {
            this.put = 0;
            this.hit = 0;
            this.miss = 0;
            this.evict = 0;
        }
    }

    class BaseCacheHandler
    implements CacheHandler {
        BaseCacheHandler() {
        }

        @Override
        public void put(int evaluatorIndex, Range range, Object value) {
            PTFValueCache.this.cache[evaluatorIndex].put(range, value);
            if (PTFValueCache.this.cache[evaluatorIndex].size() > PTFValueCache.this.maxSizePerEvaluator) {
                PTFValueCache.this.cache[evaluatorIndex].pollFirstEntry();
            }
        }

        @Override
        public Object get(int evaluatorIndex, Range range) {
            return PTFValueCache.this.cache[evaluatorIndex].get(range);
        }

        @Override
        public String getStatistics() {
            return null;
        }
    }

    private static interface CacheHandler {
        public Object get(int var1, Range var2);

        public void put(int var1, Range var2, Object var3);

        public String getStatistics();

        default public void clear() {
        }
    }
}

