/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.PartitionTableFunctionDescription;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.ql.udf.ptf.TableFunctionResolver;
import org.apache.hive.common.util.AnnotationUtils;

public class FunctionInfo {
    private final FunctionType functionType;
    private final boolean isInternalTableFunction;
    private final String displayName;
    private final FunctionResource[] resources;
    private String className;
    protected GenericUDF genericUDF;
    protected GenericUDTF genericUDTF;
    private GenericUDAFResolver genericUDAFResolver;
    private Class<? extends TableFunctionResolver> tableFunctionResolver;
    private boolean blockedFunction;
    private AtomicBoolean discarded;

    public FunctionInfo(String displayName, String className, FunctionResource ... resources) {
        this.functionType = FunctionType.PERSISTENT;
        this.displayName = displayName;
        this.className = className;
        this.isInternalTableFunction = false;
        this.resources = resources;
        this.discarded = new AtomicBoolean(false);
    }

    public FunctionInfo(FunctionType functionType, String displayName, GenericUDF genericUDF, FunctionResource ... resources) {
        this.functionType = functionType;
        this.displayName = displayName;
        this.genericUDF = genericUDF;
        this.isInternalTableFunction = false;
        this.resources = resources;
    }

    public FunctionInfo(FunctionType functionType, String displayName, GenericUDAFResolver genericUDAFResolver, FunctionResource ... resources) {
        this.functionType = functionType;
        this.displayName = displayName;
        this.genericUDAFResolver = genericUDAFResolver;
        this.isInternalTableFunction = false;
        this.resources = resources;
    }

    public FunctionInfo(FunctionType functionType, String displayName, GenericUDTF genericUDTF, FunctionResource ... resources) {
        this.functionType = functionType;
        this.displayName = displayName;
        this.genericUDTF = genericUDTF;
        this.isInternalTableFunction = false;
        this.resources = resources;
    }

    public FunctionInfo(FunctionType functionType, String displayName, Class<? extends TableFunctionResolver> tFnCls, FunctionResource ... resources) {
        this.functionType = functionType;
        this.displayName = displayName;
        this.tableFunctionResolver = tFnCls;
        PartitionTableFunctionDescription def = (PartitionTableFunctionDescription)AnnotationUtils.getAnnotation(this.tableFunctionResolver, PartitionTableFunctionDescription.class);
        this.isInternalTableFunction = def != null && def.isInternal();
        this.resources = resources;
    }

    public FunctionInfo(FunctionType functionType, String displayName, Class<? extends TableFunctionResolver> tFnCls, GenericUDF genericUDF, GenericUDTF genericUDTF, GenericUDAFResolver genericUDAFResolver, String className, FunctionResource ... resources) {
        this.functionType = functionType;
        this.displayName = displayName;
        this.tableFunctionResolver = tFnCls;
        PartitionTableFunctionDescription def = this.tableFunctionResolver != null ? (PartitionTableFunctionDescription)AnnotationUtils.getAnnotation(this.tableFunctionResolver, PartitionTableFunctionDescription.class) : null;
        this.genericUDF = genericUDF;
        this.genericUDTF = genericUDTF;
        this.genericUDAFResolver = genericUDAFResolver;
        this.className = className;
        this.isInternalTableFunction = def != null && def.isInternal();
        this.resources = resources;
    }

    public GenericUDF getGenericUDF() {
        if (this.genericUDF == null) {
            return null;
        }
        return FunctionRegistry.cloneGenericUDF(this.genericUDF);
    }

    public GenericUDTF getGenericUDTF() {
        if (this.genericUDTF == null) {
            return null;
        }
        return FunctionRegistry.cloneGenericUDTF(this.genericUDTF);
    }

    public GenericUDAFResolver getGenericUDAFResolver() {
        return this.genericUDAFResolver;
    }

    public Class<?> getFunctionClass() {
        if (this.isGenericUDF()) {
            if (this.genericUDF instanceof GenericUDFBridge) {
                return ((GenericUDFBridge)this.genericUDF).getUdfClass();
            }
            return this.genericUDF.getClass();
        }
        if (this.isGenericUDAF()) {
            if (this.genericUDAFResolver instanceof GenericUDAFBridge) {
                return ((GenericUDAFBridge)this.genericUDAFResolver).getUDAFClass();
            }
            return this.genericUDAFResolver.getClass();
        }
        if (this.isGenericUDTF()) {
            return this.genericUDTF.getClass();
        }
        if (this.isTableFunction()) {
            return this.tableFunctionResolver;
        }
        return null;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isNative() {
        return this.functionType == FunctionType.BUILTIN || this.functionType == FunctionType.PERSISTENT;
    }

    public boolean isInternalTableFunction() {
        return this.isInternalTableFunction;
    }

    public boolean isGenericUDF() {
        return null != this.genericUDF;
    }

    public boolean isGenericUDAF() {
        return null != this.genericUDAFResolver;
    }

    public boolean isGenericUDTF() {
        return null != this.genericUDTF;
    }

    public Class<? extends TableFunctionResolver> getTableFunctionResolver() {
        return this.tableFunctionResolver;
    }

    public boolean isTableFunction() {
        return null != this.tableFunctionResolver;
    }

    public boolean isBlockedFunction() {
        return this.blockedFunction;
    }

    public void setBlockedFunction(boolean blockedFunction) {
        this.blockedFunction = blockedFunction;
    }

    public boolean isBuiltIn() {
        return this.functionType == FunctionType.BUILTIN;
    }

    public boolean isPersistent() {
        return this.functionType == FunctionType.PERSISTENT;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public FunctionResource[] getResources() {
        return this.resources;
    }

    public void discarded() {
        if (this.discarded != null) {
            this.discarded.set(true);
        }
    }

    public boolean isDiscarded() {
        return this.discarded != null && this.discarded.get();
    }

    public void shareStateWith(FunctionInfo function) {
        if (function != null) {
            function.discarded = this.discarded;
        }
    }

    public FunctionType getFunctionType() {
        return this.functionType;
    }

    public static enum FunctionType {
        BUILTIN,
        PERSISTENT,
        TEMPORARY;

    }

    public static class FunctionResource {
        private final SessionState.ResourceType resourceType;
        private final String resourceURI;

        public FunctionResource(SessionState.ResourceType resourceType, String resourceURI) {
            this.resourceType = resourceType;
            this.resourceURI = resourceURI;
        }

        public SessionState.ResourceType getResourceType() {
            return this.resourceType;
        }

        public String getResourceURI() {
            return this.resourceURI;
        }

        public String toString() {
            return this.resourceType + ":" + this.resourceURI;
        }
    }
}

