/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.drop;

import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.drop.DropResourcePlanDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={1011})
public class DropResourcePlanAnalyzer
extends BaseSemanticAnalyzer {
    public DropResourcePlanAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        if (root.getChildCount() == 0) {
            throw new SemanticException("Expected name in DROP RESOURCE PLAN statement");
        }
        String resourcePlanName = DropResourcePlanAnalyzer.unescapeIdentifier(root.getChild(0).getText());
        boolean ifExists = false;
        block3: for (int i = 1; i < root.getChildCount(); ++i) {
            Tree child = root.getChild(i);
            switch (child.getType()) {
                case 1050: {
                    ifExists = true;
                    continue block3;
                }
                default: {
                    throw new SemanticException("Invalid create arguments " + root.toStringTree());
                }
            }
        }
        DropResourcePlanDesc desc = new DropResourcePlanDesc(resourcePlanName, ifExists);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
        DDLUtils.addServiceOutput(this.conf, this.getOutputs());
    }
}

