/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.function.show;

import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.function.show.ShowFunctionsDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={1207})
public class ShowFunctionsAnalyzer
extends BaseSemanticAnalyzer {
    public ShowFunctionsAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        ShowFunctionsDesc desc;
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        if (root.getChildCount() > 0) {
            assert (root.getChildCount() == 2);
            assert (root.getChild(0).getType() == 203);
            String functionNames = ShowFunctionsAnalyzer.stripQuotes(root.getChild(1).getText());
            desc = new ShowFunctionsDesc(this.ctx.getResFile(), functionNames);
        } else {
            desc = new ShowFunctionsDesc(this.ctx.getResFile());
        }
        Task<DDLWork> task = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc));
        this.rootTasks.add(task);
        task.setFetchSource(true);
        this.setFetchTask(this.createFetchTask("tab_name#string"));
    }
}

