/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.dataconnector.alter.owner;

import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.dataconnector.alter.AbstractAlterDataConnectorAnalyzer;
import org.apache.hadoop.hive.ql.ddl.dataconnector.alter.owner.AlterDataConnectorSetOwnerDesc;
import org.apache.hadoop.hive.ql.ddl.privilege.PrincipalDesc;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.authorization.AuthorizationParseUtils;

@DDLSemanticAnalyzerFactory.DDLType(types={844})
public class AlterDataConnectorSetOwnerAnalyzer
extends AbstractAlterDataConnectorAnalyzer {
    public AlterDataConnectorSetOwnerAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        String connectorName = AlterDataConnectorSetOwnerAnalyzer.getUnescapedName((ASTNode)root.getChild(0));
        PrincipalDesc principalDesc = AuthorizationParseUtils.getPrincipalDesc((ASTNode)root.getChild(1));
        if (principalDesc.getName() == null) {
            throw new SemanticException("Owner name can't be null in alter connector set owner command");
        }
        if (principalDesc.getType() == null) {
            throw new SemanticException("Owner type can't be null in alter connector set owner command");
        }
        AlterDataConnectorSetOwnerDesc desc = new AlterDataConnectorSetOwnerDesc(connectorName, principalDesc);
        this.addAlterDataConnectorDesc(desc);
    }
}

