/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.database.lock;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.database.lock.LockDatabaseDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={1087})
public class LockDatabaseAnalyzer
extends BaseSemanticAnalyzer {
    public LockDatabaseAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        String databaseName = LockDatabaseAnalyzer.unescapeIdentifier(root.getChild(0).getText());
        String mode = LockDatabaseAnalyzer.unescapeIdentifier(root.getChild(1).getText().toUpperCase());
        this.inputs.add(new ReadEntity(this.getDatabase(databaseName)));
        this.outputs.add(new WriteEntity(this.getDatabase(databaseName), WriteEntity.WriteType.DDL_NO_LOCK));
        LockDatabaseDesc desc = new LockDatabaseDesc(databaseName, mode, HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_ID), this.ctx.getCmd());
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
        this.ctx.setNeedLockMgr(true);
    }
}

