/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.jmx;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.collector.collect.common.cache.AbstractConnection;
import org.apache.hertzbeat.collector.collect.common.cache.CacheIdentifier;
import org.apache.hertzbeat.collector.collect.common.cache.GlobalConnectionCache;
import org.apache.hertzbeat.collector.collect.common.cache.JmxConnect;
import org.apache.hertzbeat.collector.collect.jmx.CustomizedJmxFactory;
import org.apache.hertzbeat.collector.collect.jmx.JmxClassLoader;
import org.apache.hertzbeat.collector.collect.jmx.MbeanProcessor;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.JmxProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.apache.hertzbeat.common.util.LogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JmxCollectImpl
extends AbstractCollect {
    private static final String JMX_URL_PREFIX = "service:jmx:rmi:///jndi/rmi://";
    private static final String JMX_URL_SUFFIX = "/jmxrmi";
    private static final String IGNORED_STUB = "/stub/";
    private static final String SUB_ATTRIBUTE = "->";
    private final GlobalConnectionCache connectionCommonCache = GlobalConnectionCache.getInstance();
    private final ClassLoader jmxClassLoader = new JmxClassLoader(ClassLoader.getSystemClassLoader());
    private static final Logger logger = LoggerFactory.getLogger(JmxCollectImpl.class);

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        Assert.isTrue((metrics != null && metrics.getJmx() != null ? 1 : 0) != 0, (String)"JMX collect must have JMX params");
        JmxProtocol jmxProtocol = metrics.getJmx();
        String url = jmxProtocol.getUrl();
        if (StringUtils.hasText((String)url)) {
            Assert.doesNotContain((String)url, (String)IGNORED_STUB, (String)"JMX url prohibit contains stub, please check");
            this.validateJmxUrl(url);
        } else {
            String host = jmxProtocol.getHost();
            int port = Integer.parseInt(jmxProtocol.getPort());
            Assert.isTrue((boolean)this.isValidHostname(host), (String)"Invalid hostname format");
            Assert.isTrue((port > 0 && port <= 65535 ? 1 : 0) != 0, (String)"Port must be between 1 and 65535");
        }
    }

    private void validateJmxUrl(String url) throws IllegalArgumentException {
        String[] disallowedPatterns;
        Assert.isTrue((boolean)url.startsWith("service:jmx:rmi:"), (String)"Only service:jmx:rmi protocol is supported");
        for (String pattern : disallowedPatterns = new String[]{"ldap:", "rmi:", "iiop:", "nis:", "dns:", "corbaname:", "http:", "https:"}) {
            if (!url.contains(pattern) || pattern.equals("rmi:///jndi/rmi:")) continue;
            throw new IllegalArgumentException("Potentially unsafe JNDI protocol detected in URL: " + pattern);
        }
        if (url.contains("${") || url.contains("$[") || url.contains(":#") || url.contains(":/")) {
            throw new IllegalArgumentException("Potentially malicious pattern detected in JMX URL");
        }
    }

    private boolean isValidHostname(String hostname) {
        if (hostname == null || hostname.isEmpty()) {
            return false;
        }
        String hostnameRegex = "^([a-zA-Z0-9][-a-zA-Z0-9]*\\.)+[a-zA-Z0-9][-a-zA-Z0-9]*$|^(\\d{1,3}\\.){3}\\d{1,3}$|^([0-9a-fA-F]{0,4}:){2,7}[0-9a-fA-F]{0,4}$";
        return hostname.matches(hostnameRegex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect(CollectRep.MetricsData.Builder builder, Metrics metrics) {
        String errorMsg;
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.jmxClassLoader);
        try {
            JmxProtocol jmxProtocol = metrics.getJmx();
            MbeanProcessor processor = null;
            if (CustomizedJmxFactory.validate(builder.getApp(), jmxProtocol.getObjectName()) && (processor = CustomizedJmxFactory.getProcessor(builder.getApp(), jmxProtocol.getObjectName())) != null) {
                processor.preProcess(builder, metrics);
                if (processor.isCollectionComplete().booleanValue()) {
                    return;
                }
            }
            JMXConnector jmxConnector = this.getConnectSession(jmxProtocol);
            MBeanServerConnection serverConnection = jmxConnector.getMBeanServerConnection();
            ObjectName objectName = new ObjectName(jmxProtocol.getObjectName());
            Set attributeNameSet = metrics.getAliasFields().stream().map(field -> field.split(SUB_ATTRIBUTE)[0]).collect(Collectors.toSet());
            Set<ObjectInstance> objectInstanceSet = serverConnection.queryMBeans(objectName, null);
            for (ObjectInstance objectInstance : objectInstanceSet) {
                ObjectName currentObjectName = objectInstance.getObjectName();
                MBeanInfo beanInfo = serverConnection.getMBeanInfo(currentObjectName);
                MBeanAttributeInfo[] attrInfos = beanInfo.getAttributes();
                String[] attributes = new String[attributeNameSet.size()];
                attributes = Arrays.stream(attrInfos).filter(item -> item.isReadable() && attributeNameSet.contains(item.getName())).map(MBeanFeatureInfo::getName).toList().toArray(attributes);
                AttributeList attributeList = serverConnection.getAttributes(currentObjectName, attributes);
                Map<String, String> attributeValueMap = this.extractAttributeValue(attributeList);
                CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
                if (processor != null) {
                    processor.process(serverConnection, objectInstance, objectInstanceSet, currentObjectName, attributeValueMap, valueRowBuilder);
                }
                for (String aliasField : metrics.getAliasFields()) {
                    String fieldValue = attributeValueMap.get(aliasField);
                    valueRowBuilder.addColumn(fieldValue != null ? fieldValue : "&nbsp;");
                }
                builder.addValueRow(valueRowBuilder.build());
                if (processor == null || !processor.isCollectionComplete().booleanValue()) continue;
                return;
            }
        }
        catch (IOException exception) {
            errorMsg = CommonUtil.getMessageFromThrowable((Throwable)exception);
            LogUtil.error((Logger)logger, (String)"JMX IOException: {0}", (Object[])new Object[]{errorMsg});
            builder.setCode(CollectRep.Code.UN_CONNECTABLE);
            builder.setMsg(errorMsg);
        }
        catch (Exception e) {
            errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e);
            LogUtil.error((Logger)logger, (String)"JMX Error: {0}", (Object[])new Object[]{errorMsg});
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    public String supportProtocol() {
        return "jmx";
    }

    private Map<String, String> extractAttributeValue(AttributeList attributeList) {
        if (attributeList == null || attributeList.isEmpty()) {
            throw new RuntimeException("attributeList is empty");
        }
        HashMap<String, String> attributeValueMap = new HashMap<String, String>(attributeList.size());
        for (Attribute attribute : attributeList.asList()) {
            Object value = attribute.getValue();
            if (value == null) {
                LogUtil.info((Logger)logger, (String)"attribute {0} value is null.", (Object[])new Object[]{attribute.getName()});
                continue;
            }
            if (value instanceof Number || value instanceof String || value instanceof ObjectName || value instanceof Boolean || value instanceof Date || value instanceof TimeUnit) {
                attributeValueMap.put(attribute.getName(), value.toString());
                continue;
            }
            if (value instanceof CompositeData) {
                CompositeData compositeData = (CompositeData)value;
                CompositeType compositeType = compositeData.getCompositeType();
                for (String typeKey : compositeType.keySet()) {
                    Object fieldValue = compositeData.get(typeKey);
                    attributeValueMap.put(attribute.getName() + SUB_ATTRIBUTE + typeKey, fieldValue.toString());
                }
                continue;
            }
            if (value instanceof String[]) {
                String[] values = (String[])value;
                StringBuilder builder = new StringBuilder();
                for (int index = 0; index < values.length; ++index) {
                    builder.append(values[index]);
                    if (index >= values.length - 1) continue;
                    builder.append(",");
                }
                attributeValueMap.put(attribute.getName(), builder.toString());
                continue;
            }
            LogUtil.warn((Logger)logger, (String)"attribute value type {0} not support.", (Object[])new Object[]{value.getClass().getName()});
        }
        return attributeValueMap;
    }

    private JMXConnector getConnectSession(JmxProtocol jmxProtocol) throws IOException {
        Object url;
        CacheIdentifier identifier = CacheIdentifier.builder().ip(jmxProtocol.getHost()).port(jmxProtocol.getPort()).username(jmxProtocol.getUsername()).password(jmxProtocol.getPassword()).build();
        Optional cacheOption = this.connectionCommonCache.getCache((Object)identifier, true);
        JMXConnector conn = null;
        if (cacheOption.isPresent()) {
            JmxConnect jmxConnect = (JmxConnect)cacheOption.get();
            conn = jmxConnect.getConnection();
            try {
                conn.getMBeanServerConnection();
            }
            catch (Exception e) {
                conn = null;
                this.connectionCommonCache.removeCache((Object)identifier);
            }
        }
        if (conn != null) {
            return conn;
        }
        if (jmxProtocol.getUrl() != null) {
            url = jmxProtocol.getUrl();
            if (!((String)url).startsWith("service:jmx:rmi:")) {
                throw new IOException("Unsupported JMX URL protocol. Only service:jmx:rmi: is allowed.");
            }
        } else {
            String host = jmxProtocol.getHost();
            int port = Integer.parseInt(jmxProtocol.getPort());
            if (!this.isValidHostname(host)) {
                throw new IOException("Invalid hostname format for JMX connection: " + host);
            }
            if (port <= 0 || port > 65535) {
                throw new IOException("Invalid port for JMX connection: " + port);
            }
            url = JMX_URL_PREFIX + host + ":" + port + JMX_URL_SUFFIX;
        }
        System.setProperty("com.sun.jndi.rmi.object.trustURLCodebase", "false");
        System.setProperty("com.sun.jndi.cosnaming.object.trustURLCodebase", "false");
        HashMap<String, Object> environment = new HashMap<String, Object>(4);
        if (StringUtils.hasText((String)jmxProtocol.getUsername()) && StringUtils.hasText((String)jmxProtocol.getPassword())) {
            String[] credential = new String[]{jmxProtocol.getUsername(), jmxProtocol.getPassword()};
            environment.put("jmx.remote.credentials", credential);
        }
        if (Boolean.TRUE.toString().equals(jmxProtocol.getSsl())) {
            environment.put("java.naming.security.protocol", "ssl");
            SslRMIClientSocketFactory clientSocketFactory = new SslRMIClientSocketFactory();
            environment.put("jmx.remote.rmi.client.socket.factory", clientSocketFactory);
            environment.put("com.sun.jndi.rmi.factory.socket", clientSocketFactory);
        }
        environment.put("jmx.remote.x.client.connection.timeout", 10000);
        environment.put("jmx.remote.x.server.connection.timeout", 10000);
        try {
            JMXServiceURL jmxServiceUrl = new JMXServiceURL((String)url);
            conn = JMXConnectorFactory.connect(jmxServiceUrl, environment);
            this.connectionCommonCache.addCache((Object)identifier, (AbstractConnection)new JmxConnect(conn));
            return conn;
        }
        catch (Exception e) {
            LogUtil.error((Logger)logger, (String)"Failed to connect to JMX connection: {0}", (Object[])new Object[]{e.getMessage()});
            throw new IOException("Failed to connect to JMX server: " + e.getMessage(), e);
        }
    }
}

