/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.alerter;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.Map;
import org.apache.hertzbeat.common.entity.alerter.JsonMapAttributeConverter;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="hzb_alert_single", indexes={@Index(name="unique_fingerprint", columnList="fingerprint", unique=true)})
@Schema(description="Single Alarm Content Entity")
@EntityListeners(value={AuditingEntityListener.class})
public class SingleAlert {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Schema(title="Threshold Id", example="87584674384", accessMode=Schema.AccessMode.READ_ONLY)
    private Long id;
    @Schema(title="Fingerprint", example="alertname:demo")
    @Column(length=2048)
    private String fingerprint;
    @Schema(title="Labels", example="{\"alertname\": \"HighCPUUsage\", \"priority\": \"critical\", \"instance\": \"343483943\"}")
    @Convert(converter=JsonMapAttributeConverter.class)
    @Column(length=2048)
    private Map<String, String> labels;
    @Schema(title="Annotations", example="{\"summary\": \"High CPU usage detected\"}")
    @Convert(converter=JsonMapAttributeConverter.class)
    @Column(length=4096)
    private Map<String, String> annotations;
    @Schema(title="Content", example="CPU usage is above 80% for the last 5 minutes on instance server1.example.com.")
    @Column(length=4096)
    private String content;
    @Schema(title="Status", example="firing|resolved")
    private String status;
    @Schema(title="Trigger Times", example="1")
    private Integer triggerTimes;
    @Schema(title="Start At", example="1734005477630")
    private Long startAt;
    @Schema(title="Active At", example="1734005477630")
    private Long activeAt;
    @Schema(title="End At, when status is resolved has", example="null")
    private Long endAt;
    @Schema(title="The creator of this record", example="tom")
    @CreatedBy
    private String creator;
    @Schema(title="This record was last modified by", example="tom")
    @LastModifiedBy
    private String modifier;
    @Schema(title="This record creation time (millisecond timestamp)")
    @CreatedDate
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime gmtCreate;
    @Schema(title="Record the latest modification time (timestamp in milliseconds)")
    @LastModifiedDate
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime gmtUpdate;

    public SingleAlert clone() {
        return JsonUtil.fromJson(JsonUtil.toJson(this), SingleAlert.class);
    }

    public static SingleAlertBuilder builder() {
        return new SingleAlertBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public String getContent() {
        return this.content;
    }

    public String getStatus() {
        return this.status;
    }

    public Integer getTriggerTimes() {
        return this.triggerTimes;
    }

    public Long getStartAt() {
        return this.startAt;
    }

    public Long getActiveAt() {
        return this.activeAt;
    }

    public Long getEndAt() {
        return this.endAt;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public LocalDateTime getGmtCreate() {
        return this.gmtCreate;
    }

    public LocalDateTime getGmtUpdate() {
        return this.gmtUpdate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setTriggerTimes(Integer triggerTimes) {
        this.triggerTimes = triggerTimes;
    }

    public void setStartAt(Long startAt) {
        this.startAt = startAt;
    }

    public void setActiveAt(Long activeAt) {
        this.activeAt = activeAt;
    }

    public void setEndAt(Long endAt) {
        this.endAt = endAt;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public void setGmtCreate(LocalDateTime gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public void setGmtUpdate(LocalDateTime gmtUpdate) {
        this.gmtUpdate = gmtUpdate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleAlert)) {
            return false;
        }
        SingleAlert other = (SingleAlert)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$triggerTimes = this.getTriggerTimes();
        Integer other$triggerTimes = other.getTriggerTimes();
        if (this$triggerTimes == null ? other$triggerTimes != null : !((Object)this$triggerTimes).equals(other$triggerTimes)) {
            return false;
        }
        Long this$startAt = this.getStartAt();
        Long other$startAt = other.getStartAt();
        if (this$startAt == null ? other$startAt != null : !((Object)this$startAt).equals(other$startAt)) {
            return false;
        }
        Long this$activeAt = this.getActiveAt();
        Long other$activeAt = other.getActiveAt();
        if (this$activeAt == null ? other$activeAt != null : !((Object)this$activeAt).equals(other$activeAt)) {
            return false;
        }
        Long this$endAt = this.getEndAt();
        Long other$endAt = other.getEndAt();
        if (this$endAt == null ? other$endAt != null : !((Object)this$endAt).equals(other$endAt)) {
            return false;
        }
        String this$fingerprint = this.getFingerprint();
        String other$fingerprint = other.getFingerprint();
        if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
            return false;
        }
        Map<String, String> this$labels = this.getLabels();
        Map<String, String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        Map<String, String> this$annotations = this.getAnnotations();
        Map<String, String> other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        LocalDateTime this$gmtCreate = this.getGmtCreate();
        LocalDateTime other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        LocalDateTime this$gmtUpdate = this.getGmtUpdate();
        LocalDateTime other$gmtUpdate = other.getGmtUpdate();
        return !(this$gmtUpdate == null ? other$gmtUpdate != null : !((Object)this$gmtUpdate).equals(other$gmtUpdate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SingleAlert;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $triggerTimes = this.getTriggerTimes();
        result = result * 59 + ($triggerTimes == null ? 43 : ((Object)$triggerTimes).hashCode());
        Long $startAt = this.getStartAt();
        result = result * 59 + ($startAt == null ? 43 : ((Object)$startAt).hashCode());
        Long $activeAt = this.getActiveAt();
        result = result * 59 + ($activeAt == null ? 43 : ((Object)$activeAt).hashCode());
        Long $endAt = this.getEndAt();
        result = result * 59 + ($endAt == null ? 43 : ((Object)$endAt).hashCode());
        String $fingerprint = this.getFingerprint();
        result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
        Map<String, String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        Map<String, String> $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        LocalDateTime $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        LocalDateTime $gmtUpdate = this.getGmtUpdate();
        result = result * 59 + ($gmtUpdate == null ? 43 : ((Object)$gmtUpdate).hashCode());
        return result;
    }

    public String toString() {
        return "SingleAlert(id=" + this.getId() + ", fingerprint=" + this.getFingerprint() + ", labels=" + this.getLabels() + ", annotations=" + this.getAnnotations() + ", content=" + this.getContent() + ", status=" + this.getStatus() + ", triggerTimes=" + this.getTriggerTimes() + ", startAt=" + this.getStartAt() + ", activeAt=" + this.getActiveAt() + ", endAt=" + this.getEndAt() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", gmtCreate=" + this.getGmtCreate() + ", gmtUpdate=" + this.getGmtUpdate() + ")";
    }

    public SingleAlert(Long id, String fingerprint, Map<String, String> labels, Map<String, String> annotations, String content, String status, Integer triggerTimes, Long startAt, Long activeAt, Long endAt, String creator, String modifier, LocalDateTime gmtCreate, LocalDateTime gmtUpdate) {
        this.id = id;
        this.fingerprint = fingerprint;
        this.labels = labels;
        this.annotations = annotations;
        this.content = content;
        this.status = status;
        this.triggerTimes = triggerTimes;
        this.startAt = startAt;
        this.activeAt = activeAt;
        this.endAt = endAt;
        this.creator = creator;
        this.modifier = modifier;
        this.gmtCreate = gmtCreate;
        this.gmtUpdate = gmtUpdate;
    }

    public SingleAlert() {
    }

    public static class SingleAlertBuilder {
        private Long id;
        private String fingerprint;
        private Map<String, String> labels;
        private Map<String, String> annotations;
        private String content;
        private String status;
        private Integer triggerTimes;
        private Long startAt;
        private Long activeAt;
        private Long endAt;
        private String creator;
        private String modifier;
        private LocalDateTime gmtCreate;
        private LocalDateTime gmtUpdate;

        SingleAlertBuilder() {
        }

        public SingleAlertBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public SingleAlertBuilder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public SingleAlertBuilder labels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public SingleAlertBuilder annotations(Map<String, String> annotations) {
            this.annotations = annotations;
            return this;
        }

        public SingleAlertBuilder content(String content) {
            this.content = content;
            return this;
        }

        public SingleAlertBuilder status(String status) {
            this.status = status;
            return this;
        }

        public SingleAlertBuilder triggerTimes(Integer triggerTimes) {
            this.triggerTimes = triggerTimes;
            return this;
        }

        public SingleAlertBuilder startAt(Long startAt) {
            this.startAt = startAt;
            return this;
        }

        public SingleAlertBuilder activeAt(Long activeAt) {
            this.activeAt = activeAt;
            return this;
        }

        public SingleAlertBuilder endAt(Long endAt) {
            this.endAt = endAt;
            return this;
        }

        public SingleAlertBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public SingleAlertBuilder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
        public SingleAlertBuilder gmtCreate(LocalDateTime gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
        public SingleAlertBuilder gmtUpdate(LocalDateTime gmtUpdate) {
            this.gmtUpdate = gmtUpdate;
            return this;
        }

        public SingleAlert build() {
            return new SingleAlert(this.id, this.fingerprint, this.labels, this.annotations, this.content, this.status, this.triggerTimes, this.startAt, this.activeAt, this.endAt, this.creator, this.modifier, this.gmtCreate, this.gmtUpdate);
        }

        public String toString() {
            return "SingleAlert.SingleAlertBuilder(id=" + this.id + ", fingerprint=" + this.fingerprint + ", labels=" + this.labels + ", annotations=" + this.annotations + ", content=" + this.content + ", status=" + this.status + ", triggerTimes=" + this.triggerTimes + ", startAt=" + this.startAt + ", activeAt=" + this.activeAt + ", endAt=" + this.endAt + ", creator=" + this.creator + ", modifier=" + this.modifier + ", gmtCreate=" + this.gmtCreate + ", gmtUpdate=" + this.gmtUpdate + ")";
        }
    }
}

