/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.changedetector;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixProperty;
import org.apache.helix.controller.changedetector.ChangeDetector;
import org.apache.helix.controller.changedetector.ResourceChangeSnapshot;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.model.ClusterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceChangeDetector
implements ChangeDetector {
    private static final Logger LOG = LoggerFactory.getLogger((String)ResourceChangeDetector.class.getName());
    private final boolean _ignoreNonTopologyChange;
    private ResourceChangeSnapshot _oldSnapshot;
    private ResourceChangeSnapshot _newSnapshot;
    private Map<HelixConstants.ChangeType, Collection<String>> _changedItems = new HashMap<HelixConstants.ChangeType, Collection<String>>();
    private Map<HelixConstants.ChangeType, Collection<String>> _addedItems = new HashMap<HelixConstants.ChangeType, Collection<String>>();
    private Map<HelixConstants.ChangeType, Collection<String>> _removedItems = new HashMap<HelixConstants.ChangeType, Collection<String>>();

    public ResourceChangeDetector(boolean ignoreNonTopologyChange) {
        this._newSnapshot = new ResourceChangeSnapshot();
        this._ignoreNonTopologyChange = ignoreNonTopologyChange;
    }

    public ResourceChangeDetector() {
        this(false);
    }

    private Collection<String> getChangedItems(Map<String, ? extends HelixProperty> oldPropertyMap, Map<String, ? extends HelixProperty> newPropertyMap) {
        HashSet<String> changedItems = new HashSet<String>();
        oldPropertyMap.forEach((name, property) -> {
            if (newPropertyMap.containsKey(name) && !property.getRecord().equals(((HelixProperty)newPropertyMap.get(name)).getRecord())) {
                changedItems.add((String)name);
            }
        });
        return changedItems;
    }

    private Collection<String> getAddedItems(Map<String, ? extends HelixProperty> oldPropertyMap, Map<String, ? extends HelixProperty> newPropertyMap) {
        return Sets.difference(newPropertyMap.keySet(), oldPropertyMap.keySet());
    }

    private Collection<String> getRemovedItems(Map<String, ? extends HelixProperty> oldPropertyMap, Map<String, ? extends HelixProperty> newPropertyMap) {
        return Sets.difference(oldPropertyMap.keySet(), newPropertyMap.keySet());
    }

    private void clearCachedComputation() {
        this._changedItems.clear();
        this._addedItems.clear();
        this._removedItems.clear();
    }

    private Map<String, ? extends HelixProperty> determinePropertyMapByType(HelixConstants.ChangeType changeType, ResourceChangeSnapshot snapshot) {
        switch (changeType) {
            case INSTANCE_CONFIG: {
                return snapshot.getAssignableInstanceConfigMap();
            }
            case IDEAL_STATE: {
                return snapshot.getIdealStateMap();
            }
            case RESOURCE_CONFIG: {
                return snapshot.getResourceConfigMap();
            }
            case LIVE_INSTANCE: {
                return snapshot.getAssignableLiveInstances();
            }
            case CLUSTER_CONFIG: {
                ClusterConfig config = snapshot.getClusterConfig();
                if (config == null) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(config.getClusterName(), config);
            }
        }
        LOG.warn("ResourceChangeDetector cannot determine propertyMap for the given ChangeType: {}. Returning an empty map.", (Object)changeType);
        return Collections.emptyMap();
    }

    public synchronized void updateSnapshots(ResourceControllerDataProvider dataProvider) {
        this._oldSnapshot = new ResourceChangeSnapshot(this._newSnapshot);
        this._newSnapshot = new ResourceChangeSnapshot(dataProvider, this._ignoreNonTopologyChange);
        dataProvider.clearRefreshedChangeTypes();
        this.clearCachedComputation();
    }

    public synchronized void resetSnapshots() {
        this._newSnapshot = new ResourceChangeSnapshot();
        this.clearCachedComputation();
    }

    @Override
    public synchronized Collection<HelixConstants.ChangeType> getChangeTypes() {
        return Collections.unmodifiableSet(this._newSnapshot.getChangedTypes());
    }

    @Override
    public synchronized Collection<String> getChangesByType(HelixConstants.ChangeType changeType) {
        return this._changedItems.computeIfAbsent(changeType, changedItems -> this.getChangedItems(this.determinePropertyMapByType(changeType, this._oldSnapshot), this.determinePropertyMapByType(changeType, this._newSnapshot)));
    }

    @Override
    public synchronized Collection<String> getAdditionsByType(HelixConstants.ChangeType changeType) {
        return this._addedItems.computeIfAbsent(changeType, changedItems -> this.getAddedItems(this.determinePropertyMapByType(changeType, this._oldSnapshot), this.determinePropertyMapByType(changeType, this._newSnapshot)));
    }

    @Override
    public synchronized Collection<String> getRemovalsByType(HelixConstants.ChangeType changeType) {
        return this._removedItems.computeIfAbsent(changeType, changedItems -> this.getRemovedItems(this.determinePropertyMapByType(changeType, this._oldSnapshot), this.determinePropertyMapByType(changeType, this._newSnapshot)));
    }

    public Map<HelixConstants.ChangeType, Set<String>> getAllChanges() {
        return this.getChangeTypes().stream().collect(Collectors.toMap(changeType -> changeType, changeType -> {
            HashSet<String> itemKeys = new HashSet<String>();
            itemKeys.addAll(this.getAdditionsByType((HelixConstants.ChangeType)((Object)changeType)));
            itemKeys.addAll(this.getChangesByType((HelixConstants.ChangeType)((Object)changeType)));
            itemKeys.addAll(this.getRemovalsByType((HelixConstants.ChangeType)((Object)changeType)));
            return itemKeys;
        })).entrySet().stream().filter(changeEntry -> !((Set)changeEntry.getValue()).isEmpty()).collect(Collectors.toMap(changeEntry -> (HelixConstants.ChangeType)((Object)((Object)changeEntry.getKey())), changeEntry -> (Set)changeEntry.getValue()));
    }
}

