/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.io.Serializable;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.java.io.CollectionInputFormat;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.file.src.FileSource;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.enumerate.BlockSplittingRecursiveAllDirEnumerator;
import org.apache.flink.connector.file.src.enumerate.NonSplittingRecursiveAllDirEnumerator;
import org.apache.flink.connector.file.src.enumerate.NonSplittingRecursiveEnumerator;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.table.AbstractFileSystemTable;
import org.apache.flink.connector.file.table.DeserializationSchemaAdapter;
import org.apache.flink.connector.file.table.FileInfoExtractorBulkFormat;
import org.apache.flink.connector.file.table.FileSystemConnectorOptions;
import org.apache.flink.connector.file.table.LimitableBulkFormat;
import org.apache.flink.connector.file.table.ProjectingBulkFormat;
import org.apache.flink.connector.file.table.format.BulkDecodingFormat;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.FileBasedStatisticsReportableInputFormat;
import org.apache.flink.table.connector.format.ProjectableDecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.InputFormatProvider;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceProvider;
import org.apache.flink.table.connector.source.abilities.SupportsFilterPushDown;
import org.apache.flink.table.connector.source.abilities.SupportsLimitPushDown;
import org.apache.flink.table.connector.source.abilities.SupportsPartitionPushDown;
import org.apache.flink.table.connector.source.abilities.SupportsProjectionPushDown;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.connector.source.abilities.SupportsStatisticReport;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.PartitionPathUtils;
import org.apache.flink.util.CollectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class FileSystemTableSource
extends AbstractFileSystemTable
implements ScanTableSource,
SupportsProjectionPushDown,
SupportsLimitPushDown,
SupportsPartitionPushDown,
SupportsFilterPushDown,
SupportsReadingMetadata,
SupportsStatisticReport {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemTableSource.class);
    @Nullable
    private final DecodingFormat<BulkFormat<RowData, FileSourceSplit>> bulkReaderFormat;
    @Nullable
    private final DecodingFormat<DeserializationSchema<RowData>> deserializationFormat;
    private List<Map<String, String>> remainingPartitions;
    private List<ResolvedExpression> filters;
    private Long limit;
    private int[][] projectFields;
    private List<String> metadataKeys;
    private DataType producedDataType;

    public FileSystemTableSource(ObjectIdentifier tableIdentifier, DataType physicalRowDataType, List<String> partitionKeys, ReadableConfig tableOptions, @Nullable DecodingFormat<BulkFormat<RowData, FileSourceSplit>> bulkReaderFormat, @Nullable DecodingFormat<DeserializationSchema<RowData>> deserializationFormat) {
        super(tableIdentifier, physicalRowDataType, partitionKeys, tableOptions);
        if (Stream.of(bulkReaderFormat, deserializationFormat).allMatch(Objects::isNull)) {
            String identifier = (String)tableOptions.get(FactoryUtil.FORMAT);
            throw new ValidationException(String.format("Could not find any format factory for identifier '%s' in the classpath.", identifier));
        }
        this.bulkReaderFormat = bulkReaderFormat;
        this.deserializationFormat = deserializationFormat;
        this.producedDataType = physicalRowDataType;
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext scanContext) {
        if (!this.partitionKeys.isEmpty() && this.getOrFetchPartitions().isEmpty()) {
            return InputFormatProvider.of((InputFormat)new CollectionInputFormat(new ArrayList(), null));
        }
        List<Object> metadataKeys = this.metadataKeys == null ? Collections.emptyList() : this.metadataKeys;
        List<ReadableFileInfo> metadataToExtract = metadataKeys.stream().map(ReadableFileInfo::resolve).collect(Collectors.toList());
        List<String> partitionKeysToExtract = DataType.getFieldNames((DataType)this.producedDataType).stream().filter(this.partitionKeys::contains).collect(Collectors.toList());
        DataType physicalDataType = this.physicalRowDataType;
        Projection partitionKeysProjections = Projection.fromFieldNames((DataType)physicalDataType, (List)this.partitionKeys);
        Projection physicalProjections = (this.projectFields != null ? Projection.of((int[][])this.projectFields) : Projection.all((DataType)physicalDataType)).difference(partitionKeysProjections);
        physicalDataType = partitionKeysProjections.complement(physicalDataType).project(physicalDataType);
        if (this.bulkReaderFormat != null) {
            if (this.bulkReaderFormat instanceof BulkDecodingFormat && this.filters != null && this.filters.size() > 0) {
                ((BulkDecodingFormat)this.bulkReaderFormat).applyFilters(this.filters);
            }
            BulkFormat<Object, FileSourceSplit> format = this.bulkReaderFormat instanceof ProjectableDecodingFormat ? (BulkFormat<RowData, FileSourceSplit>)((ProjectableDecodingFormat)this.bulkReaderFormat).createRuntimeDecoder((DynamicTableSource.Context)scanContext, physicalDataType, physicalProjections.toNestedIndexes()) : new ProjectingBulkFormat((BulkFormat)this.bulkReaderFormat.createRuntimeDecoder((DynamicTableSource.Context)scanContext, physicalDataType), physicalProjections.toTopLevelIndexes(), (TypeInformation<RowData>)scanContext.createTypeInformation(physicalProjections.project(physicalDataType)));
            format = this.wrapBulkFormat(scanContext, format, this.producedDataType, metadataToExtract, partitionKeysToExtract);
            return this.createSourceProvider(format);
        }
        if (this.deserializationFormat != null) {
            BulkFormat<RowData, FileSourceSplit> format = this.deserializationFormat instanceof ProjectableDecodingFormat ? new DeserializationSchemaAdapter((DeserializationSchema<RowData>)((DeserializationSchema)((ProjectableDecodingFormat)this.deserializationFormat).createRuntimeDecoder((DynamicTableSource.Context)scanContext, physicalDataType, physicalProjections.toNestedIndexes()))) : new ProjectingBulkFormat(new DeserializationSchemaAdapter((DeserializationSchema<RowData>)((DeserializationSchema)this.deserializationFormat.createRuntimeDecoder((DynamicTableSource.Context)scanContext, physicalDataType))), physicalProjections.toTopLevelIndexes(), (TypeInformation<RowData>)scanContext.createTypeInformation(physicalProjections.project(physicalDataType)));
            format = this.wrapBulkFormat(scanContext, format, this.producedDataType, metadataToExtract, partitionKeysToExtract);
            return this.createSourceProvider(format);
        }
        throw new TableException("Can not find format factory.");
    }

    private BulkFormat<RowData, FileSourceSplit> wrapBulkFormat(ScanTableSource.ScanContext context, BulkFormat<RowData, FileSourceSplit> bulkFormat, DataType producedDataType, List<ReadableFileInfo> metadata, List<String> partitionKeys) {
        if (!metadata.isEmpty() || !partitionKeys.isEmpty()) {
            List producedFieldNames = DataType.getFieldNames((DataType)producedDataType);
            Map<String, FileInfoAccessor> metadataColumns = IntStream.range(0, metadata.size()).mapToObj(i -> {
                int columnPos = producedFieldNames.size() - metadata.size() + i;
                return CollectionUtil.entry(producedFieldNames.get(columnPos), (Object)((ReadableFileInfo)metadata.get(i)).getAccessor());
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            bulkFormat = new FileInfoExtractorBulkFormat(bulkFormat, producedDataType, (TypeInformation<RowData>)context.createTypeInformation(producedDataType), metadataColumns, partitionKeys, this.defaultPartName);
        }
        bulkFormat = LimitableBulkFormat.create(bulkFormat, this.limit);
        return bulkFormat;
    }

    private SourceProvider createSourceProvider(BulkFormat<RowData, FileSourceSplit> bulkFormat) {
        FileSource.FileSourceBuilder<RowData> fileSourceBuilder = FileSource.forBulkFileFormat(bulkFormat, this.paths());
        this.tableOptions.getOptional(FileSystemConnectorOptions.SOURCE_MONITOR_INTERVAL).ifPresent(x$0 -> fileSourceBuilder.monitorContinuously((Duration)x$0));
        this.tableOptions.getOptional(FileSystemConnectorOptions.SOURCE_PATH_REGEX_PATTERN).ifPresent(regex -> {
            FileSource.FileSourceBuilder cfr_ignored_0 = (FileSource.FileSourceBuilder)fileSourceBuilder.setFileEnumerator(bulkFormat.isSplittable() ? () -> new BlockSplittingRecursiveAllDirEnumerator((String)regex) : () -> new NonSplittingRecursiveAllDirEnumerator((String)regex));
        });
        return SourceProvider.of((Source)fileSourceBuilder.build());
    }

    private Path[] paths() {
        if (this.partitionKeys.isEmpty()) {
            return new Path[]{this.path};
        }
        return (Path[])this.getOrFetchPartitions().stream().map(this::toFullLinkedPartSpec).map(PartitionPathUtils::generatePartitionPath).map(n -> new Path(this.path, n)).toArray(Path[]::new);
    }

    public ChangelogMode getChangelogMode() {
        if (this.bulkReaderFormat != null) {
            return this.bulkReaderFormat.getChangelogMode();
        }
        if (this.deserializationFormat != null) {
            return this.deserializationFormat.getChangelogMode();
        }
        throw new TableException("Can not find format factory.");
    }

    public SupportsFilterPushDown.Result applyFilters(List<ResolvedExpression> filters) {
        this.filters = new ArrayList<ResolvedExpression>(filters);
        return SupportsFilterPushDown.Result.of(new ArrayList<ResolvedExpression>(filters), new ArrayList<ResolvedExpression>(filters));
    }

    public void applyLimit(long limit) {
        this.limit = limit;
    }

    public Optional<List<Map<String, String>>> listPartitions() {
        try {
            return Optional.of(PartitionPathUtils.searchPartSpecAndPaths((FileSystem)this.path.getFileSystem(), (Path)this.path, (int)this.partitionKeys.size()).stream().map(tuple2 -> (LinkedHashMap)tuple2.f0).map(spec -> {
                LinkedHashMap ret = new LinkedHashMap();
                spec.forEach((k, v) -> ret.put(k, this.defaultPartName.equals(v) ? null : v));
                return ret;
            }).collect(Collectors.toList()));
        }
        catch (Exception e) {
            throw new TableException("Fetch partitions fail.", (Throwable)e);
        }
    }

    public void applyPartitions(List<Map<String, String>> remainingPartitions) {
        this.remainingPartitions = remainingPartitions;
    }

    public boolean supportsNestedProjection() {
        return false;
    }

    public TableStats reportStatistics() {
        try {
            Optional monitorIntervalOpt = this.tableOptions.getOptional(FileSystemConnectorOptions.SOURCE_MONITOR_INTERVAL);
            if (monitorIntervalOpt.isPresent() && ((Duration)monitorIntervalOpt.get()).toMillis() <= 0L) {
                return TableStats.UNKNOWN;
            }
            if (this.tableOptions.get(FileSystemConnectorOptions.SOURCE_REPORT_STATISTICS) == FileSystemConnectorOptions.FileStatisticsType.NONE) {
                return TableStats.UNKNOWN;
            }
            NonSplittingRecursiveEnumerator enumerator = new NonSplittingRecursiveEnumerator();
            Collection<FileSourceSplit> splits = enumerator.enumerateSplits(this.paths(), 1);
            List files = splits.stream().map(FileSourceSplit::path).collect(Collectors.toList());
            if (this.bulkReaderFormat instanceof FileBasedStatisticsReportableInputFormat) {
                TableStats tableStats = ((FileBasedStatisticsReportableInputFormat)this.bulkReaderFormat).reportStatistics(files, this.producedDataType);
                if (tableStats.equals((Object)TableStats.UNKNOWN)) {
                    return tableStats;
                }
                return this.limit == null ? tableStats : new TableStats(Math.min(this.limit, tableStats.getRowCount()));
            }
            if (this.deserializationFormat instanceof FileBasedStatisticsReportableInputFormat) {
                TableStats tableStats = ((FileBasedStatisticsReportableInputFormat)this.deserializationFormat).reportStatistics(files, this.producedDataType);
                if (tableStats.equals((Object)TableStats.UNKNOWN)) {
                    return tableStats;
                }
                return this.limit == null ? tableStats : new TableStats(Math.min(this.limit, tableStats.getRowCount()));
            }
            return TableStats.UNKNOWN;
        }
        catch (Exception e) {
            LOG.warn("Reporting statistics failed for file system table source: {}", (Object)e.getMessage());
            return TableStats.UNKNOWN;
        }
    }

    public FileSystemTableSource copy() {
        FileSystemTableSource source = new FileSystemTableSource(this.tableIdentifier, this.physicalRowDataType, this.partitionKeys, (ReadableConfig)this.tableOptions, this.bulkReaderFormat, this.deserializationFormat);
        source.partitionKeys = this.partitionKeys;
        source.remainingPartitions = this.remainingPartitions;
        source.filters = this.filters;
        source.limit = this.limit;
        source.projectFields = this.projectFields;
        source.metadataKeys = this.metadataKeys;
        source.producedDataType = this.producedDataType;
        return source;
    }

    public String asSummaryString() {
        return "Filesystem";
    }

    private List<Map<String, String>> getOrFetchPartitions() {
        if (this.remainingPartitions == null) {
            this.remainingPartitions = this.listPartitions().get();
        }
        return this.remainingPartitions;
    }

    private LinkedHashMap<String, String> toFullLinkedPartSpec(Map<String, String> part) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String k : this.partitionKeys) {
            if (!part.containsKey(k)) {
                throw new TableException("Partition keys are: " + this.partitionKeys + ", incomplete partition spec: " + part);
            }
            map.put(k, part.get(k));
        }
        return map;
    }

    public void applyProjection(int[][] projectedFields, DataType producedDataType) {
        this.projectFields = projectedFields;
        this.producedDataType = producedDataType;
    }

    public void applyReadableMetadata(List<String> metadataKeys, DataType producedDataType) {
        this.metadataKeys = metadataKeys;
        this.producedDataType = producedDataType;
    }

    public Map<String, DataType> listReadableMetadata() {
        return Arrays.stream(ReadableFileInfo.values()).collect(Collectors.toMap(ReadableFileInfo::getKey, ReadableFileInfo::getDataType));
    }

    static enum ReadableFileInfo implements Serializable
    {
        FILEPATH("file.path", (DataType)DataTypes.STRING().notNull(), new FileInfoAccessor(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object getValue(FileSourceSplit split) {
                return StringData.fromString((String)split.path().getPath());
            }
        }),
        FILENAME("file.name", (DataType)DataTypes.STRING().notNull(), new FileInfoAccessor(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object getValue(FileSourceSplit split) {
                return StringData.fromString((String)Paths.get(split.path().getPath(), new String[0]).getFileName().toString());
            }
        }),
        SIZE("file.size", (DataType)DataTypes.BIGINT().notNull(), new FileInfoAccessor(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object getValue(FileSourceSplit split) {
                return split.fileSize();
            }
        }),
        MODIFICATION_TIME("file.modification-time", (DataType)DataTypes.TIMESTAMP_LTZ((int)3).notNull(), new FileInfoAccessor(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object getValue(FileSourceSplit split) {
                return TimestampData.fromEpochMillis((long)split.fileModificationTime());
            }
        });

        final String key;
        final DataType dataType;
        final FileInfoAccessor converter;

        private ReadableFileInfo(String key, DataType dataType, FileInfoAccessor converter) {
            this.key = key;
            this.dataType = dataType;
            this.converter = converter;
        }

        public String getKey() {
            return this.key;
        }

        public DataType getDataType() {
            return this.dataType;
        }

        public FileInfoAccessor getAccessor() {
            return this.converter;
        }

        public static ReadableFileInfo resolve(String key) {
            return Arrays.stream(ReadableFileInfo.values()).filter(readableFileInfo -> readableFileInfo.getKey().equals(key)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot resolve the provided ReadableMetadata key"));
        }
    }

    static interface FileInfoAccessor
    extends Serializable {
        public Object getValue(FileSourceSplit var1);
    }
}

