/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.utils.SizeFormatterUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryManager
implements ActiveMQComponent {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Runtime runtime = Runtime.getRuntime();
    private final long measureInterval;
    private final int memoryWarningThreshold;
    private volatile boolean started;
    private Thread thread;
    private volatile boolean low;

    public MemoryManager(int memoryWarningThreshold, long measureInterval) {
        this.measureInterval = measureInterval;
        this.memoryWarningThreshold = memoryWarningThreshold;
    }

    public boolean isMemoryLow() {
        return this.low;
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    public synchronized void start() {
        if (logger.isDebugEnabled()) {
            logger.debug("Starting MemoryManager with MEASURE_INTERVAL: {} FREE_MEMORY_PERCENT: {}", (Object)this.measureInterval, (Object)this.memoryWarningThreshold);
        }
        if (this.started) {
            return;
        }
        this.started = true;
        this.thread = new Thread((Runnable)new MemoryRunnable(), "activemq-memory-manager-thread");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class MemoryRunnable
    implements Runnable {
        private MemoryRunnable() {
        }

        @Override
        public void run() {
            while (true) {
                StringBuilder info;
                block6: {
                    try {
                        if (MemoryManager.this.thread.isInterrupted() && !MemoryManager.this.started) break;
                        Thread.sleep(MemoryManager.this.measureInterval);
                    }
                    catch (InterruptedException ignore) {
                        if (MemoryManager.this.started) break block6;
                        return;
                    }
                }
                long maxMemory = MemoryManager.this.runtime.maxMemory();
                long totalMemory = MemoryManager.this.runtime.totalMemory();
                long freeMemory = MemoryManager.this.runtime.freeMemory();
                long availableMemory = freeMemory + maxMemory - totalMemory;
                double availableMemoryPercent = 100.0 * (double)availableMemory / (double)maxMemory;
                boolean availableBelowThreshold = availableMemoryPercent <= (double)MemoryManager.this.memoryWarningThreshold;
                boolean prepareInfo = availableBelowThreshold || logger.isDebugEnabled();
                StringBuilder stringBuilder = info = prepareInfo ? new StringBuilder() : null;
                if (prepareInfo) {
                    info.append(String.format("free memory:      %s%n", SizeFormatterUtil.sizeof((long)freeMemory)));
                    info.append(String.format("max memory:       %s%n", SizeFormatterUtil.sizeof((long)maxMemory)));
                    info.append(String.format("total memory:     %s%n", SizeFormatterUtil.sizeof((long)totalMemory)));
                    info.append(String.format("available memory: %.2f%%%n", availableMemoryPercent));
                }
                if (prepareInfo && logger.isDebugEnabled()) {
                    logger.debug(info.toString());
                }
                if (availableBelowThreshold) {
                    ActiveMQServerLogger.LOGGER.memoryError(MemoryManager.this.memoryWarningThreshold, info.toString());
                    MemoryManager.this.low = true;
                    continue;
                }
                MemoryManager.this.low = false;
            }
        }
    }
}

